
require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(false);

MakeDialog
{
	SHShopLoop
	{
	    name="shshoploop",
		x = 0,
		y = 0,
		w = 800,
		h = 600,
		
		Bitmap
        {
            image = "shop/border_bottom",
            flags=kHAlignCenter+kVAlignBottom,
            x=kCenter,
            y=500,
        },
        Bitmap
        {
            image = "shop/border_top",
            flags=kHAlignCenter+kVAlignTop,
            x=kCenter,
            y=0,
        },
        Bitmap
        {
            image = "shop/border_left",
            flags=kHAlignLeft+kVAlignCenter,
            x=0,
            y=40,
        },
        Bitmap
        {
            image = "shop/border_right",
            flags=kHAlignRight+kVAlignCenter,
            x=-16,
            y=40,
        },
		
		SHButtonsPanel
		{
		    name="shbuttonspanel",
		    x = 164,
		    y = 498,
		    w = 470,
		    h = 80,
		},

		SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
		Text
		{
            	name="cash",
		    x=694,y=5,
		    w=kMax,h=30,
		    flags=kHAlignLeft+kVAlignCenter,
		},
		
		
		SetStyle(CreateTextStyle(FontGame, 19, BlackColor)),
		Text
		{
            	name="description",
		    x=kCenter,y=574,
		    w=kMax,h=30,
		},
		
		Bitmap
		{
		    name="left_arrow_panel",
		    image="ui/buttons/shop_arrow_l_dis",
		    x = 128, y = 520,

            SetStyle(CreatePushButtonStyle(ShopLeftArrowGraphics, DefaultButtonSound)),
            Button
            {
                name = "left_arrow",
                x = 0, y = 0,
                sendToParent = true,
                command=
                    function()
                        RollRight();
			        end
            },
		},
		
		Bitmap
		{
		    name="right_arrow_panel",
		    image="ui/buttons/shop_arrow_r_dis",
		    x = 634, y = 520,
		    
		    SetStyle(CreatePushButtonStyle(ShopRightArrowGraphics, DefaultButtonSound)),
            Button
            {
                name = "right_arrow",
                x = 0, y = 0,
                sendToParent = true,
                command=
                    function()
                        RollLeft();
			        end
            },
		},
		
		SetStyle({});
        Bitmap
        {
            image = ShopButtonGraphics[1],
            x = 14, y = 540,
            
            SetStyle(CreateTextStyle(FontButtons, 24, WhiteColor)),
            CreateText(2,2,"tomainmenu", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
            CreateText(0,0,"tomainmenu", 0, 0),
                
            SetStyle(CreatePushButtonStyle(ShopButtonGraphics, DefaultButtonSound)),
            Button
            {
                name = "tomainmenu",
                x = kCenter, y = kCenter,
		        command=
			        function()
					        result = DisplayDialog {
						        "scripts/yesno.lua",
						        body ="quitmenuconfirm",
						        title = "quitmenutitle"
					        };
					        if (result=='yes') then
		                        ToMenu();
					        end
			        end,
			        
				SetStyle(CreateTextStyle(FontButtons, 24, WhiteColorAlpha128)),
				CreateText(2,2,"tomainmenu", 0, 0),
				SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
				CreateText(0,0,"tomainmenu", 0, 0),
            },
        },

        SetStyle({});
        Bitmap
        {
            image = ShopButtonGraphics[1],
            x = 685, y = 540,

            SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
            CreateText(2,2,"continue", 0, 0),
            SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
            CreateText(0,0,"continue", 0, 0),

            SetStyle(CreatePushButtonStyle(ShopButtonGraphics, DefaultButtonSound)),
            Button
            {
                x = kCenter, y = kCenter,
                name = "continue",
                command = function()
                        ToGame(); 
                    end;

				SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
				CreateText(2,2,"continue", 0, 0),
				SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
				CreateText(0,0,"continue", 0, 0),
            },
        },

        SetStyle({}),
        SHPanelTutorial
        {
            name = "cdpaneltutorialsh",

            x = 300,
            y = -1000,
            w = 800,
            h = 600,

            Bitmap
            {
                name="hintsh",
                image = "ui/surfaces/panel_tutorial",
                x=0,
                y=0,
                w = 800,
                h = 600,
                
                SetStyle(CreateTextStyle(FontComics, 24, BlackColor)),
                Text
                {
                    x=30,
                    y=10,
                    w = kMax-38,
                    h = kMax-10,
                    name="tutorialtext",
                },
            },
            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=11,
                y=460,
                name="skip",
                flags=kHAlignLeft,
                command = function() 
                    SkipSHTutorial(); 
                end,
                SetStyle(CreateTextStyle(FontButtons, 24, WhiteColorAlpha128)),
                CreateText(2,2,"skiptutorial", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
                CreateText(0,0,"skiptutorial", 0, 0),
            },
        },
    },
}
